import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import MonitoraggioSpecieForm from "../../../../core/Forms/MonitoraggioSpecieForm/MonitoraggioSpecieForm";
import MonitoraggioHabitatForm from "../../../../core/Forms/MonitoraggioHabitatForm/MonitoraggioHabitatForm"
import {authUserQuery, monitoraggioHabitatQuery} from "../../../../api/queries";
import {findById} from "../../../../utils";
import Loading from "../../../../core/Loading/Loading";

class Edit extends Component {

    constructor(props) {
        super(props);

        this.state = {
            submitting: false,
            error: false,
        };
    }

    render() {
        const {
            data,
            utenteSessione
        } = this.props;

        if(data.loading) {
            return (<Loading/>);
        }

        return (<div className="container" style={{marginBottom: '20px'}}>
            <h1>Salva Monitoraggio Habitat</h1>
            <MonitoraggioHabitatForm
                data={data}
                utenteSessione={utenteSessione}
                submitMutation={gql`
                    mutation($monitoraggio: MonitoraggioHabitatInput) {
                        updateMonitoraggioHabitat(monitoraggioHabitat: $monitoraggio) {
                            id
                        }
                    }`} />
        </div>);
    }
}

export default compose(
    graphql(monitoraggioHabitatQuery, {
        options:({match}) => ({variables: {id: match.params.id}}),
    }),
    graphql(authUserQuery, {name: 'utenteSessione'})
)(Edit);

Edit.defaultProps = {};

Edit.propTypes = {};